# Iranian Gateways Dashboard - Design Specification

## Overview

This document provides complete design specifications for the Iranian Gateways WordPress admin dashboard, including visual design, component specifications, and design tokens.

## Design Philosophy

- **Modern Iranian Aesthetic**: Clean, professional design with Persian typography
- **RTL-First**: Built from the ground up for right-to-left languages
- **Accessibility**: WCAG 2.1 AA compliant
- **Responsive**: Mobile-first approach
- **Theme-Aware**: Seamless light/dark mode support

## Visual Design

### Layout Structure

```
┌─────────────────────────────────────────────────┐
│  Header (Title + Theme Toggle)                 │
├─────────────────────────────────────────────────┤
│  [Gateway Card 1]    [Gateway Card 2]         │
│  ┌──────────────┐     ┌──────────────┐         │
│  │ Icon + Title │     │ Icon + Title │         │
│  │ Description  │     │ Description  │         │
│  │ [Toggle]     │     │ [Toggle]     │         │
│  │ Status Badge │     │ Status Badge │         │
│  │ [Settings]   │     │ [Settings]   │         │
│  └──────────────┘     └──────────────┘         │
│                                                  │
│  [Expanded Settings Form]                       │
│  ┌──────────────────────────────────────┐      │
│  │ Section 1: Basic Settings            │      │
│  │ Section 2: Account Settings         │      │
│  │ Section 3: Messages                  │      │
│  │ [Save] [Cancel]                      │      │
│  └──────────────────────────────────────┘      │
└─────────────────────────────────────────────────┘
```

### Color System

#### Light Theme

| Token | Color | Usage |
|-------|-------|-------|
| `--irandargah-primary` | `#0066CC` | Primary actions, links, accents |
| `--irandargah-primary-dark` | `#0052A3` | Hover states |
| `--irandargah-secondary` | `#0A33FF` | Zarinpal branding |
| `--irandargah-accent` | `#FF6B35` | Highlights, warnings |
| `--irandargah-success` | `#10B981` | Success states, active toggles |
| `--irandargah-error` | `#EF4444` | Errors, destructive actions |
| `--irandargah-warning` | `#F59E0B` | Warnings, sandbox mode |
| `--irandargah-bg-primary` | `#FFFFFF` | Main background |
| `--irandargah-bg-secondary` | `#F9FAFB` | Secondary background |
| `--irandargah-bg-tertiary` | `#F3F4F6` | Tertiary background |
| `--irandargah-text-primary` | `#111827` | Primary text |
| `--irandargah-text-secondary` | `#6B7280` | Secondary text |
| `--irandargah-text-tertiary` | `#9CA3AF` | Tertiary text |
| `--irandargah-border` | `#E5E7EB` | Borders, dividers |

#### Dark Theme

| Token | Color | Usage |
|-------|-------|-------|
| `--irandargah-bg-primary` | `#1F2937` | Main background |
| `--irandargah-bg-secondary` | `#111827` | Secondary background |
| `--irandargah-bg-tertiary` | `#0F172A` | Tertiary background |
| `--irandargah-text-primary` | `#F9FAFB` | Primary text |
| `--irandargah-text-secondary` | `#D1D5DB` | Secondary text |
| `--irandargah-text-tertiary` | `#9CA3AF` | Tertiary text |
| `--irandargah-border` | `#374151` | Borders, dividers |
| `--irandargah-card-bg` | `#1F2937` | Card backgrounds |

### Typography

#### Font Stack

```css
font-family: 'Vazir', 'Tahoma', 'Arial', sans-serif;
```

- **Primary**: Vazir (Google Fonts) - Persian-optimized
- **Fallback**: Tahoma, Arial for compatibility

#### Type Scale

| Element | Size | Weight | Line Height |
|---------|------|--------|-------------|
| Page Title | 1.875rem (30px) | 700 | 1.2 |
| Gateway Title | 1.5rem (24px) | 700 | 1.3 |
| Section Title | 1.25rem (20px) | 600 | 1.4 |
| Body Text | 0.875rem (14px) | 400 | 1.6 |
| Small Text | 0.75rem (12px) | 400 | 1.5 |
| Label | 0.875rem (14px) | 500 | 1.4 |

### Spacing System

Based on 4px grid:

- **XS**: 0.25rem (4px)
- **SM**: 0.5rem (8px)
- **MD**: 1rem (16px)
- **LG**: 1.5rem (24px)
- **XL**: 2rem (32px)
- **2XL**: 3rem (48px)

### Border Radius

- **SM**: 0.375rem (6px) - Small elements
- **MD**: 0.5rem (8px) - Inputs, buttons
- **LG**: 0.75rem (12px) - Cards, large buttons
- **XL**: 1rem (16px) - Main containers

### Shadows

```css
--irandargah-shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
--irandargah-shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
--irandargah-shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
--irandargah-shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
```

## Component Specifications

### Gateway Card

**Dimensions:**
- Min-width: 400px (desktop)
- Max-width: 100% (mobile)
- Padding: 2rem (32px)
- Border-radius: 1rem (16px)

**States:**
- Default: Shadow MD, border
- Hover: Shadow XL, translateY(-4px)
- Active: Border color primary

**Content:**
- Icon: 48x48px SVG
- Title: 1.5rem, bold
- Description: 0.875rem, secondary color
- Toggle: 60x32px
- Status badge: Inline, rounded
- Settings button: Primary style

### Toggle Switch

**Dimensions:**
- Width: 60px
- Height: 32px
- Slider: 24x24px circle
- Border-radius: 32px (fully rounded)

**States:**
- Off: Gray background (#F3F4F6)
- On: Success green (#10B981)
- Transition: 0.3s cubic-bezier

**Animation:**
- Slider moves 28px on toggle
- Smooth color transition

### Form Inputs

**Text Input / Textarea:**
- Padding: 1rem (16px)
- Border: 1px solid border color
- Border-radius: 0.5rem (8px)
- Focus: Primary border + shadow ring

**Select:**
- Same as text input
- Custom dropdown arrow

**Checkbox:**
- Size: 20x20px
- Border-radius: 0.25rem (4px)
- Checkmark: Primary color

### Buttons

**Primary Button:**
- Background: Primary color
- Text: White
- Padding: 0.75rem 1.5rem
- Border-radius: 0.75rem
- Hover: Darker shade, translateY(-2px)

**Secondary Button:**
- Background: Tertiary
- Text: Primary text color
- Border: 1px solid border color

**Success Button:**
- Background: Success green
- Same styling as primary

### Status Badges

**Active:**
- Background: Light green (#D1FAE5)
- Text: Dark green (#065F46)
- Padding: 0.25rem 1rem
- Border-radius: 0.5rem

**Inactive:**
- Background: Light red (#FEE2E2)
- Text: Dark red (#991B1B)

**Sandbox:**
- Background: Light yellow (#FEF3C7)
- Text: Dark yellow (#92400E)

## Responsive Breakpoints

- **Mobile**: < 768px
- **Tablet**: 768px - 1024px
- **Desktop**: > 1024px

### Mobile Adaptations

- Single column grid
- Full-width buttons
- Stacked card header
- Reduced padding (1rem)
- Larger touch targets (44px min)

## Animations

### Transitions

```css
transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
```

### Keyframe Animations

**Slide Down:**
```css
@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
```

**Fade In:**
```css
@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}
```

## Icon Specifications

### Menu Icon
- Size: 20x20px
- Style: Minimal, geometric
- Color: Inherits from theme

### Gateway Icons
- Size: 48x48px
- Background: Brand color (rounded square)
- Icon: White, centered
- Border-radius: 12px

## Accessibility

### Color Contrast

All text meets WCAG 2.1 AA:
- Normal text: 4.5:1 minimum
- Large text: 3:1 minimum
- Interactive elements: 3:1 minimum

### Keyboard Navigation

- Tab order: Logical flow
- Focus indicators: Visible outline
- Skip links: Available

### Screen Readers

- Semantic HTML
- ARIA labels where needed
- Alt text for icons
- Status announcements

## Design Files

### Figma/Adobe XD Structure

1. **Frames:**
   - Dashboard - Desktop (1440x900)
   - Dashboard - Tablet (768x1024)
   - Dashboard - Mobile (375x667)
   - Settings Expanded
   - Dark Theme Variants

2. **Components:**
   - Gateway Card
   - Toggle Switch
   - Form Input
   - Button (Primary, Secondary, Success)
   - Status Badge
   - Header

3. **Styles:**
   - Color Palette (Light/Dark)
   - Typography Scale
   - Effects (Shadows, Blur)
   - Grid System

## Implementation Notes

- Use CSS custom properties for theming
- RTL support via `direction: rtl`
- Flexbox/Grid for layouts
- Mobile-first media queries
- Smooth transitions on all interactive elements

## Design Tokens Export

All design tokens are available as CSS custom properties in `admin/assets/css/dashboard.css` for easy theming and customization.















