# ایران درگاه - مدیریت مرکزی درگاه‌های پرداخت ایرانی

یک افزونه جامع و قدرتمند برای مدیریت مرکزی تمام درگاه‌های پرداخت ایرانی در ووکامرس با داشبورد پیشرفته و سیستم گزارش‌دهی هوشمند.

## 📋 فهرست مطالب

- [ویژگی‌ها](#-ویژگی‌ها)
- [درگاه‌های پشتیبانی شده](#-درگاه‌های-پشتیبانی-شده)
- [نصب و راه‌اندازی](#-نصب-و-راه‌اندازی)
- [استفاده](#-استفاده)
- [ساختار فایل‌ها](#-ساختار-فایل‌ها)
- [امنیت](#-امنیت)
- [پشتیبانی](#-پشتیبانی)

## ✨ ویژگی‌ها

### 🎯 مدیریت مرکزی
- **داشبورد یکپارچه**: مدیریت تمام درگاه‌های پرداخت از یک مکان
- **فعال/غیرفعال سریع**: تغییر وضعیت درگاه‌ها با یک کلیک
- **تنظیمات متمرکز**: تمام تنظیمات درگاه‌ها در یک داشبورد
- **بدون نیاز به تغییر کد**: فقط خواندن و نوشتن در تنظیمات موجود

### 📊 داشبورد گزارشات پیشرفته
- **تحلیل‌های پیشرفته**: نمودارهای مقایسه‌ای بین درگاه‌ها
- **گزارش‌های زمانی**: روزانه، هفتگی، ماهانه، سالانه
- **مدیریت تراکنش‌ها**: نمایش و مدیریت تراکنش‌های موفق، ناموفق و معلق
- **هشدارهای هوشمند**: اطلاع‌رسانی خودکار در صورت اختلال
- **تشخیص تقلب**: شناسایی تراکنش‌های مشکوک
- **یکپارچگی CRM**: ارسال داده‌ها به سیستم‌های CRM

### 🎨 رابط کاربری
- **طراحی مدرن RTL**: رابط کاربری کاملاً فارسی
- **تم روشن/تاریک**: قابلیت تغییر تم با انیمیشن نرم
- **واکنش‌گرا**: سازگار با موبایل، تبلت و دسکتاپ
- **به‌روزرسانی لحظه‌ای**: تغییرات فوری با AJAX

## 🏦 درگاه‌های پشتیبانی شده

این افزونه از **17 درگاه پرداخت ایرانی** پشتیبانی می‌کند:

### درگاه‌های اصلی
1. **زرین‌پال** (Zarinpal) - `WC_ZPal`
2. **بانک سامان** (Saman Bank) - `WC_Sep_Payment_Gateway`
3. **رایان‌پی** (RayanPay) - `rayanpay`

### درگاه‌های پرداخت آنلاین
4. **آقای پرداخت** (Aqayepardakht) - `WC_aqayepardakht`
5. **بیت‌پی** (BitPay) - `WC_bitpayir2`
6. **پی‌پینگ** (PayPing) - `WC_payping`
7. **باهمتا** (Bahamta) - `bahamta_payment_gateway`
8. **آی‌دی‌پی** (IDPay) - `WC_IDPay`
9. **نکست‌پی** (NextPay) - `WC_NextPay`
10. **پیمنت۴** (Payment4) - `WC_Payment4`

### درگاه‌های بانکی
11. **بانک ملی** (Melli Bank) - `melli_pay`
12. **بانک ملت** (Mellat Bank) - `WC_BankMellat`
13. **بانک پارسیان** (Parsian Bank) - `bankparsian`
14. **بانک پاسارگاد** (Pasargad Bank) - `pasargad`
15. **ایران‌کیش** (Irankish) - `irankish`
16. **سپهرپی** (SepehrPay) - `pas`
17. **فن‌آوا کارت** (FanAva) - `Fanava`

## 🚀 نصب و راه‌اندازی

### پیش‌نیازها
- WordPress 5.8 یا بالاتر
- WooCommerce 3.0 یا بالاتر
- PHP 7.4 یا بالاتر

### مراحل نصب

1. **آپلود افزونه**:
   ```bash
   # آپلود پوشه irandargah به مسیر زیر:
   /wp-content/plugins/irandargah/
   ```

2. **فعال‌سازی افزونه**:
   - به بخش **افزونه‌ها** در پیشخوان وردپرس بروید
   - افزونه **ایران درگاه** را پیدا کرده و **فعال** کنید

3. **دسترسی به داشبورد**:
   - در منوی پیشخوان، روی **Iranian Gateways** کلیک کنید
   - یا به مسیر زیر بروید: `wp-admin/admin.php?page=irandargah-dashboard`

## 📖 استفاده

### داشبورد اصلی

1. **مشاهده درگاه‌ها**:
   - تمام درگاه‌های نصب شده در یک صفحه نمایش داده می‌شوند
   - وضعیت فعال/غیرفعال هر درگاه با یک سوئیچ نمایش داده می‌شود

2. **فعال/غیرفعال کردن درگاه**:
   - روی سوئیچ کنار هر درگاه کلیک کنید
   - تغییرات به صورت لحظه‌ای اعمال می‌شود

3. **تنظیمات درگاه**:
   - روی دکمه **تنظیمات** کنار هر درگاه کلیک کنید
   - تنظیمات درگاه را ویرایش کنید
   - روی **ذخیره** کلیک کنید

### داشبورد گزارشات

1. **دسترسی به گزارشات**:
   - از منوی پیشخوان: **Iranian Gateways > گزارشات درگاه‌ها**
   - یا مسیر: `wp-admin/admin.php?page=irandargah-reports`

2. **تب‌های موجود**:
   - **تحلیل‌های پیشرفته**: نمودارها و آمار تراکنش‌ها
   - **هشدارهای هوشمند**: اطلاع‌رسانی‌های خودکار
   - **حسابرسی تراکنش‌ها**: تاریخچه کامل تراکنش‌ها
   - **مدیریت پرداخت‌های معلق**: تراکنش‌های در انتظار
   - **تشخیص تقلب**: شناسایی تراکنش‌های مشکوک
   - **یکپارچگی CRM**: اتصال به سیستم‌های CRM

3. **فیلترها**:
   - انتخاب بازه زمانی (روزانه، هفتگی، ماهانه، سالانه)
   - انتخاب درگاه خاص
   - فیلتر بر اساس نوع تراکنش (موفق، ناموفق، معلق)

### پاک‌سازی اطلاعات افزونه‌ها

سیستم پاک‌سازی به صورت خودکار فعال است و:
- اطلاعات سازنده را از لیست افزونه‌ها حذف می‌کند
- شماره نسخه را مخفی می‌کند
- سیستم آپدیت خودکار را غیرفعال می‌کند
- نوتیفیکیشن‌های غیرضروری را حذف می‌کند
- فقط دکمه فعال/غیرفعال را نمایش می‌دهد

## 📁 ساختار فایل‌ها

```
irandargah/
├── admin/                          # فایل‌های مدیریتی
│   ├── dashboard.php               # صفحه اصلی داشبورد
│   ├── reports-dashboard.php       # صفحه گزارشات
│   ├── inc/
│   │   ├── settings-loader.php     # بارگذاری تنظیمات درگاه‌ها
│   │   ├── rest-endpoints.php      # API های REST
│   │   └── gateway-cleanup.php    # سیستم پاک‌سازی
│   ├── assets/
│   │   ├── css/
│   │   │   ├── dashboard.css       # استایل داشبورد اصلی
│   │   │   └── reports-dashboard.css # استایل داشبورد گزارشات
│   │   ├── js/
│   │   │   ├── dashboard.js        # جاوااسکریپت داشبورد اصلی
│   │   │   └── reports-dashboard.js # جاوااسکریپت گزارشات
│   │   └── icons/                  # آیکون‌های درگاه‌ها
│   ├── react/                      # نسخه React (اختیاری)
│   └── vue/                        # نسخه Vue (اختیاری)
├── aqayepardakht/                  # درگاه آقای پرداخت
├── bahamta/                        # درگاه باهمتا
├── bitpay/                         # درگاه بیت‌پی
├── FanAva/                         # درگاه فن‌آوا کارت
├── idpay/                          # درگاه آی‌دی‌پی
├── irankish/                       # درگاه ایران‌کیش
├── melli/                          # درگاه بانک ملی
├── mellat/                         # درگاه بانک ملت
├── nextpay/                        # درگاه نکست‌پی
├── parsian/                        # درگاه بانک پارسیان
├── pasargad/                       # درگاه بانک پاسارگاد
├── payping/                        # درگاه پی‌پینگ
├── payment4/                       # درگاه پیمنت۴
├── rayanpay/                       # درگاه رایان‌پی
├── sepehrpay/                      # درگاه سپهرپی
├── sep/                            # درگاه بانک سامان
├── zarinpal/                       # درگاه زرین‌پال
└── irandargah.php                  # فایل اصلی افزونه
```

## 🔒 امنیت

این افزونه از بهترین روش‌های امنیتی استفاده می‌کند:

- ✅ **تأیید Nonce**: تمام فرم‌ها و درخواست‌های AJAX
- ✅ **بررسی دسترسی**: فقط کاربران با دسترسی `manage_options`
- ✅ **سانیتایز ورودی**: استفاده از `sanitize_text_field` و `sanitize_textarea_field`
- ✅ **REST API امن**: تأیید nonce در تمام درخواست‌های API
- ✅ **جلوگیری از دسترسی مستقیم**: بررسی `ABSPATH` در تمام فایل‌ها

## 🎨 طراحی

### پالت رنگ

**تم روشن:**
- Primary: `#0066CC` (آبی)
- Secondary: `#0A33FF` (آبی زرین‌پال)
- Success: `#10B981` (سبز)
- Error: `#EF4444` (قرمز)
- Background: `#FFFFFF` / `#F9FAFB`
- Text: `#111827` / `#6B7280`

**تم تاریک:**
- Primary: `#0066CC`
- Background: `#1F2937` / `#111827`
- Text: `#F9FAFB` / `#D1D5DB`

### تایپوگرافی

- فونت: Vazir (از Google Fonts)
- اندازه پایه: 14px
- سرتیترها: 1.5rem - 1.875rem
- ارتفاع خط: 1.6

### انیمیشن‌ها

- Transition: `all 0.3s cubic-bezier(0.4, 0, 0.2, 1)`
- Slide Down: 0.3s ease-out
- Toggle: انیمیشن نرم 0.3s

## 🔧 توسعه

### افزودن درگاه جدید

برای افزودن یک درگاه جدید به داشبورد:

1. **افزودن داده درگاه** در `admin/inc/settings-loader.php`:
   ```php
   public static function get_new_gateway_data() {
       $settings = get_option('woocommerce_NEW_GATEWAY_settings', []);
       return [
           'id' => 'NEW_GATEWAY',
           'title' => __('درگاه جدید', 'irandargah'),
           'description' => __('توضیحات درگاه', 'irandargah'),
           'icon' => self::get_new_gateway_icon_svg(),
           'enabled' => $settings['enabled'] ?? 'no',
           'settings_sections' => [
               // تعریف بخش‌ها و فیلدها
           ],
       ];
   }
   ```

2. **افزودن به `get_all_gateways_data()`**:
   ```php
   return [
       // ... درگاه‌های موجود
       self::get_new_gateway_data(), // افزودن اینجا
   ];
   ```

3. **افزودن به `irandargah_get_gateway_ids()`** در `irandargah.php`:
   ```php
   return [
       // ... شناسه‌های موجود
       'NEW_GATEWAY', // افزودن اینجا
   ];
   ```

4. **ایجاد آیکون SVG** در `admin/assets/icons/`

5. **افزودن به لیست پاک‌سازی** در `admin/inc/gateway-cleanup.php`:
   ```php
   self::$gateway_plugins = [
       // ... درگاه‌های موجود
       'newgateway', // افزودن اینجا
   ];
   ```

### ساخت نسخه React

```bash
cd admin/react
npm install
npm run dev      # حالت توسعه
npm run build    # ساخت نسخه تولید
```

### ساخت نسخه Vue

```bash
cd admin/vue
npm install
npm run dev      # حالت توسعه
npm run build    # ساخت نسخه تولید
```

## 🌐 پشتیبانی مرورگرها

- Chrome/Edge (آخرین نسخه)
- Firefox (آخرین نسخه)
- Safari (آخرین نسخه)
- مرورگرهای موبایل (iOS Safari, Chrome Mobile)

## 📝 مجوز

GPLv3 or later

## 🤝 مشارکت

برای گزارش باگ یا پیشنهاد ویژگی جدید، لطفاً از بخش Issues استفاده کنید.

## 📞 پشتیبانی

برای سوالات و مشکلات، لطفاً به مستندات افزونه مراجعه کنید یا با پشتیبانی تماس بگیرید.

---

**ساخته شده با ❤️ برای جامعه ووکامرس ایران**
