import React, { useState } from 'react';
import ToggleSwitch from './ToggleSwitch';
import SettingsForm from './SettingsForm';

function GatewayCard({ gateway, onToggle }) {
  const [showSettings, setShowSettings] = useState(false);

  return (
    <div className="irandargah-gateway-card" data-gateway-id={gateway.id}>
      <div className="irandargah-gateway-card-header">
        <div className="irandargah-gateway-icon" dangerouslySetInnerHTML={{ __html: gateway.icon }} />
        <div className="irandargah-gateway-info">
          <h2 className="irandargah-gateway-title">{gateway.title}</h2>
          <p className="irandargah-gateway-description">{gateway.description}</p>
        </div>
        <div className="irandargah-gateway-toggle-wrapper">
          <ToggleSwitch
            checked={gateway.enabled === 'yes'}
            onChange={(checked) => onToggle(gateway.id, checked)}
          />
        </div>
      </div>

      <div className="irandargah-gateway-status">
        <span className={`irandargah-status-badge ${
          gateway.enabled === 'yes' ? 'irandargah-status-active' : 'irandargah-status-inactive'
        }`}>
          {gateway.enabled === 'yes' ? 'فعال' : 'غیرفعال'}
        </span>
        {gateway.sandbox === 'yes' && (
          <span className="irandargah-sandbox-badge">حالت آزمایشی</span>
        )}
      </div>

      <div className="irandargah-gateway-actions">
        <button
          className="irandargah-btn irandargah-btn-primary irandargah-settings-toggle"
          onClick={() => setShowSettings(!showSettings)}
        >
          <span className="btn-icon">⚙️</span>
          تنظیمات بیشتر
        </button>
      </div>

      {showSettings && (
        <div className="irandargah-gateway-settings">
          <SettingsForm gateway={gateway} onClose={() => setShowSettings(false)} />
        </div>
      )}
    </div>
  );
}

export default GatewayCard;


