import * as React from "react";
import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import Index from "./pages/Index";
import ExtraGateways from "./pages/ExtraGateways";

const queryClient = new QueryClient({
  defaultOptions: {
    queries: {
      refetchOnWindowFocus: false,
      retry: 1,
    },
  },
});

const App = () => {
  // Check if we're on extra gateways page
  // Check for React root element ID or URL parameter or body class
  const rootElement = document.getElementById("irandargah-extra-react-root") || 
                     document.querySelector('[id*="extra-react-root"]');
  const urlParams = new URLSearchParams(window.location.search);
  const currentPage = urlParams.get('page');
  const isExtraGatewaysPage = !!rootElement ||
                               currentPage === 'irandargah-extra-gateways' ||
                               window.location.search.includes('page=irandargah-extra-gateways') || 
                               document.body.classList.contains('extra-gateways-page') ||
                               (window.location.pathname && window.location.pathname.includes('irandargah-extra-gateways'));

  // Use effect to log for debugging
  React.useEffect(() => {
    console.log('IranDargah App - Extra Gateways Page:', isExtraGatewaysPage);
    console.log('Current page:', currentPage);
    console.log('Root element:', rootElement);
  }, [isExtraGatewaysPage, currentPage, rootElement]);

  return (
  <QueryClientProvider client={queryClient}>
    <TooltipProvider>
      <Toaster />
      <Sonner />
        {isExtraGatewaysPage ? <ExtraGateways /> : <Index />}
    </TooltipProvider>
  </QueryClientProvider>
);
};

export default App;
