import { createRoot } from "react-dom/client";
import App from "./App.tsx";
import "./index.css";

// Mount React app to WordPress container
function initReactApp() {
  // Check for both main dashboard and extra gateways page
  const rootElement = document.getElementById("irandargah-react-root") || document.getElementById("irandargah-extra-react-root");
  if (rootElement) {
    const appRoot = document.createElement("div");
    appRoot.id = "root";
    rootElement.appendChild(appRoot);
    createRoot(appRoot).render(<App />);
  } else {
    console.error('IranDargah: Could not find React root element');
  }
}

// Initialize when DOM is ready
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initReactApp);
} else {
  initReactApp();
}
