<?php
// افزودن پست باکس به پیشخوان
function wszb_add_dashboard_widget() {
    wp_add_dashboard_widget(
        'wszbco_latest_posts_widget',
        'آخرین مقالات وب سازان ذهن برتر',
        'wszbco_display_latest_wszb_posts'
    );
}
add_action('wp_dashboard_setup', 'wszb_add_dashboard_widget');

// فانکشن نمایش مقالات از فید سایت
function wszbco_display_latest_wszb_posts() {
    include_once(ABSPATH . WPINC . '/feed.php');
    $rss = fetch_feed('https://wszb.ir/feed/');
    
    echo '<div class="wszbcowidget-latest-posts">';
    
    if (!is_wp_error($rss)) {
        $max_items = $rss->get_item_quantity(5);
        $rss_items = $rss->get_items(0, $max_items);
        
        if (!empty($rss_items)) {
            echo '<ul>';
            foreach ($rss_items as $item) {
                $title = esc_html($item->get_title());
                $link = esc_url($item->get_permalink());
                $date = $item->get_date('j F Y');
                
                echo '<li>';
                echo '<a href="' . $link . '" target="_blank">' . $title . '</a>';
                echo ' - <span class="post-date">' . $date . '</span>';
                echo '</li>';
            }
            echo '</ul>';
        } else {
            echo '<p>هیچ مقاله‌ای یافت نشد.</p>';
        }
    } else {
        echo '<p>خطا در دریافت فید RSS: ' . esc_html($rss->get_error_message()) . '</p>';
    }
    
    echo '<p><a href="https://wszb.ir/blog/" target="_blank">مشاهده همه مقالات</a></p>';
    echo '</div>';
    $rss->__destruct();
    unset($rss);
}

// افزودن استایل به پست باکس
function wszbco_dashboard_widget_styles() {
    wp_enqueue_style(
		'wszbco-dashboard-styles',
		plugin_dir_url(__FILE__) . 'wszbco-styles.css'
	);
}
add_action('admin_enqueue_scripts', 'wszbco_dashboard_widget_styles');
?>